﻿namespace Hims.Api.Models.Provider
{
    using System;

    /// <summary>
    /// The Time Slot Model
    /// </summary>
    public class TimeSlotModel
    {
        /// <summary>
        /// Gets or sets the slot value.
        /// </summary>
        public string SlotValue { get; set; }

        /// <summary>
        /// Gets or sets the slot time.
        /// </summary>
        public TimeSpan SlotTime { get; set; }

        /// <summary>
        /// Gets or sets the slot name.
        /// </summary>
        public string SlotName { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public SlotStatus Status { get; set; }

        /// <summary>
        /// Gets or sets the token number.
        /// </summary>
        /// <value>
        /// The token number.
        /// </value>
        public int TokenNumber { get; set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public string Value { get; set; }
    }
}